/* JAlbum tool that resets folder dates to last file date */

long lastModDate(File dir) {
	long lastMod = 0;
	for (File f : dir.listFiles()) {
		long lm = f.lastModified();
		if (lm > lastMod) {
			lastMod = lm;
		}
	}
	return lastMod;
}

Work.on(currentFolder.descendants.stream().filter(ao -> ao.isFolder()))
	.titled("Reset folder dates to last file date")
	.ask("This script will reset the date of each folder in your album to the date of the most recent image file or sub folder")
	.forEach(ao) -> {
		ao.setLastModified(lastModDate(ao.file));
	}.showResult();
